#!/bin/bash
# System Information Script

echo "=========================================="
echo "System Information"
echo "=========================================="
echo ""
echo "Hostname: $(hostname)"
echo "OS: $(lsb_release -d | cut -f2-)"
echo "Kernel: $(uname -r)"
echo "Architecture: $(uname -m)"
echo ""
echo "=========================================="
echo "CPU Information"
echo "=========================================="
echo "Model: $(lscpu | grep 'Model name' | cut -f 2 -d ':' | awk '{$1=$1}1')"
echo "Cores: $(nproc)"
echo "Load Average: $(uptime | awk -F'load average:' '{print $2}')"
echo ""
echo "=========================================="
echo "Memory Information"
echo "=========================================="
free -h
echo ""
echo "=========================================="
echo "Disk Usage"
echo "=========================================="
df -h | grep -E '(Filesystem|/dev/)'
echo ""
echo "=========================================="
echo "Top 5 Processes by CPU"
echo "=========================================="
ps aux --sort=-%cpu | head -6 | awk '{printf "%-10s %-6s %-6s %s\n", $1, $3"%", $4"%", $11}'
echo "=========================================="
